##### Rozdział 11: Jak odnieść sukces w uczeniu maszynowym --------------------

## Przykład: używanie ggplot2 do wizualnej eksploracji danych ----

# wczytujemy treningowy zbiór danych o pasażerach Titanica
titanic_train <- read.csv("titanic_train.csv")

# badamy cechy
str(titanic_train)

# wczytujemy pakiet ggplot2 i stosujemy go do zbioru danych o pasażerach Titanica
library(ggplot2)
p <- ggplot(data = titanic_train)
p # tworzy pusty szary wykres

# porównujemy wbudowany wykres skrzynkowy z wykresem skrzynkowym z pakietu ggplot2
boxplot(titanic_train$Age) # wbudowany wykres skrzynkowy
p + geom_boxplot(mapping = aes(y = Age)) # wykres skrzynkowy z ggplot2

# wykres skrzynkowy badający związek między wiekiem a przeżyciem
p + geom_boxplot(mapping = aes(x = Age, y = as.factor(Survived)))

# porównujemy wbudowany  histogram z histogramem z pakietu ggplot2
hist(titanic_train$Age) # wbudowany histogram
p + geom_histogram(aes(x = Age)) # histogram z ggplot2

# nakładające się histogramy
p + geom_histogram(aes(x = Age, fill = as.factor(Survived))) +
  ggtitle("Rozkład wieku pasażerów Titanica wg przeżycia")

# histogramy obok siebie
p + geom_histogram(aes(x = Age)) +
  facet_grid(cols = vars(Survived)) +
  ggtitle("Rozkład wieku pasażerów Titanica wg przeżycia")

# nakładające się wykresy gęstości
p + geom_density(aes(x = Age,
                     color = as.factor(Survived),
                     fill = as.factor(Survived)),
                 alpha = 0.25) +
  ggtitle("Gęstość wieku pasażerów Titanica wg przeżycia")

# wykres słupkowy liczby pasażerów Titanica wg płci
p + geom_bar(aes(x = Sex)) +
  ggtitle("Pasażerowie Titanica według płci")

# wykres słupkowy prawdopodobieństwa przeżycia wg płci
p + geom_bar(aes(x = Sex, y = Survived),
             stat = "summary", fun = "mean") +
    ggtitle("Wskaźnik przeżywalności pasażerów Titanica wg płci")


# wykres słupkowy prawdopodobieństwa przeżycia wg klasy
p + geom_bar(aes(x = Pclass, y = Survived),
             stat = "summary", fun = "mean") +
    ggtitle("Wskaźnik przeżywalności pasażerów Titanica wg klasy")

# skumulowany wykres słupkowy przeżywalności wg klasy
p + geom_bar(aes(x = Pclass,
                 fill = factor(Survived,
                               labels = c("Nie", "Tak")))) +
  labs(fill = "Przeżył") +
  ylab("Liczba pasażerów") +
  ggtitle("Liczba ocalałych pasażerów wg klasy")

# status przeżycia wg klasy
p + geom_bar(aes(x = Pclass,
                 fill = factor(Survived,
                               labels = c("Nie", "Tak"))),
             position = "fill") +
  labs(fill = "Przeżył") +
  ylab("Proporcja pasażerów") +
  ggtitle("Liczba ocalałych pasażerów wg klasy")


# wykres słupkowy interakcji między klasą a płcią
p + geom_bar(aes(x = Pclass, y = Survived, fill = Sex),
             position = "dodge", stat = "summary", fun = "mean") +
  ylab("Proporcja ocalałych") +
  ggtitle("Wskaźnik przeżywalności pasażerów Titanica wg klasy i płci")
